/*
Copyright © 2005, ladybug.fr.  All rights reserved.
Graphics, HTML, CSS & JavaScript : Fabrice Delaneau (fabrice@ladybug.fr) & Benoit Pepermans (benoit@ladybug.fr)


http://www.ladybug.fr/goodies.html

http://www.ladybug.fr/ladycrypt
----------------------------------------------------------------------------------------------

Creative Commons Licence
----------------------------------------------------------------------------------------------
This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike License.
To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/2.0/
or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
*/

var widgetVersion = '1.0';
var widgetName = 'ladyCrypt';
var XMLRequest;
var checkVersionStatus = false;
var chosenMethod = 0;
var encodedCase = "mixed";
var fullEncodedWord = "";
var pwdLength = 8;
var optionsShown = false;
var cryptMethods = [{label:"MD5", shortcut:"md5"}, {label:"Crypt", shortcut:"crypt"}];

function setup() {
	optionsFader = new Fader(document.getElementById('options'), null, 500);

	if (window.widget) {
		chosenMethod = widget.preferenceForKey(createKey("chosenMethod"));
		chosenMethod = (!chosenMethod || chosenMethod.length == 0) ? 0 : chosenMethod;

		pwdLength = widget.preferenceForKey(createKey("pwdLength"));
		pwdLength = (!pwdLength) ? 8 : pwdLength;

		encodedCase = widget.preferenceForKey(createKey("pwdCase"));
		encodedCase = (!encodedCase || encodedCase.length == 0) ? "mixed" : encodedCase;
	}

	document.getElementById('word').setAttribute("placeholder", getLocalizedString('String to encode'));
	document.getElementById('copy').setAttribute("title", getLocalizedString('Copy to clipboard'));
	document.getElementById('clear').setAttribute("title", getLocalizedString('Clear password'));
	document.getElementById('length-label').innerText = getLocalizedString('length ');
	document.getElementById('logo').innerText = widgetName+" "+widgetVersion;
	document.getElementById('passlength').value = pwdLength;
	document.getElementById('methods').options[0].selected = true;
	document.getElementById('bubble').style.visibility = "hidden";
	
	showUpdates(false);
	downloadUpdate(false);

	listMethods(document.getElementById('methods'), cryptMethods, chosenMethod);
	changeMethod();
	changeCase(encodedCase);
	setPwdLength();
}

function listMethods(ph, obj, cur) {
	ph.options[0] = null;
	
	for (var i=0; i<obj.length; i++) {
		var data = obj[i];
		var opt = new Option(data.label, i);
		ph.options[i] = opt;
	}
	if ((cur) && (cur < obj.length)) {
		ph.options[cur].selected = true;
	}
	else {
		ph.options[0].selected = true;
	}
}

function setPwdLength() {
	var pL = parseInt(document.getElementById('passlength').value);
	pwdLength = (isNaN(pL)) ? pwdLength : pL;
	if (pwdLength > 32)
		document.getElementById('passlength').value = pwdLength = 32;

	if (window.widget)
		widget.setPreferenceForKey(pwdLength, createKey("pwdLength"));	
	var eI = document.getElementById('password');
	eI.innerText = cutPassword(fullEncodedWord, pwdLength);
}

function fadeOptions(fdiv) {
	if (optionsShown) {
		fdiv.fadeOut();
		document.getElementById('btn-options').innerText = '+';
		optionsShown = false;
		window.setTimeout("window.resizeBy(0, -6)", 500);
	}
	else {
		window.resizeBy(0, 6)
		fdiv.fadeIn();
		document.getElementById('btn-options').innerText = '-';
		optionsShown = true;
	}
}

function encodeWord() {
	var clearInput = document.getElementById('word');
	var encodedInput = document.getElementById('password');
	var bubbleLayer = document.getElementById('bubble');
	
	if (clearInput.value != '') {
		switch(cryptMethods[chosenMethod].shortcut) {
			case "md5":
				fullEncodedWord = systMd5(clearInput.value);
			break;
			case "crypt":
				fullEncodedWord = systCrypt(clearInput.value);
			break;
		}
		
		encodedInput.innerText = setCase(encodedCase, cutPassword(fullEncodedWord, pwdLength));
		bubbleLayer.style.visibility = "visible";
	}
	else {
		fullEncodedWord = '';
		encodedInput.innerText = '';
		bubbleLayer.style.visibility = "hidden";
	}
}

function cutPassword(w, l) {
	return w.substr(0, l);
}

function clearPassword() {
	fullEncodedWord = '';
	document.getElementById('word').value = '';
	document.getElementById('password').innerText = '';
	document.getElementById('bubble').style.visibility = "hidden";
}

function changeMethod() {
	var eM = document.getElementById('methods');
	chosenMethod = eM.options[eM.selectedIndex].value;
	document.getElementById('methods-label').innerText = cryptMethods[chosenMethod].label;
	if (window.widget)
		widget.setPreferenceForKey(chosenMethod, createKey("chosenMethod"));
	encodeWord();
}

function changeCase(ccase) {
	var fld = document.getElementById('password');

	document.getElementById(encodedCase+'case').removeAttribute('class');
	document.getElementById(ccase+'case').setAttribute('class', 'selected');

	if (window.widget)
		widget.setPreferenceForKey(ccase, createKey("pwdCase"));
	
	fld.innerText = setCase(ccase, cutPassword(fullEncodedWord, pwdLength));
	encodedCase = ccase;
}

function getPassword() {
    return setCase(encodedCase, cutPassword(fullEncodedWord, pwdLength));
}

function setCase(ch, str) {
	switch(ch) {
		case "mixed":
			return str;
		break;
		case "upper":
			return str.toUpperCase();
		break;
		case "lower":
			return str.toLowerCase();
		break;
	}
}
	
function copyPassword() {
	widget.system("/bin/echo '"+getPassword()+"' | /usr/bin/pbcopy", null)
}

/* MD5 & Htpasswd functions : unsing system command line output */
function systMd5(str) {
	
	var md5 = widget.system("/sbin/md5 -s "+str,null);
	var md5Output = md5.outputString;
	md5 = md5Output.substr(str.length+11, md5Output.length);
	return md5;
}

function systCrypt(str) {
	var crypt = widget.system("/usr/bin/htpasswd -nb null "+str,null);
	crypt = crypt.outputString.replace("null:", "");
	return crypt;
}
/*--------------------------------------------------------------------*/

function getXML(url) {
	if (window.XMLHttpRequest) {
		XMLRequest = new XMLHttpRequest();
		XMLRequest.onreadystatechange = checkVersion;
		XMLRequest.open("GET", url, false);
		XMLRequest.send(null);
	}
}

function checkVersion() {
	var updateStatus = document.getElementById('update');
	if (XMLRequest.readyState == 4) {
		if (XMLRequest.status == 200) {
			checkVersionStatus = ladySoftwareUpdate(widgetName, widgetVersion);
			showUpdates(true);
		}
		else {
			checkVersionStatus = false;
			updateStatus.innerText = getLocalizedString('Connexion failed, try again later');
			setTimeout("checkUpdateMsg();", 5000);
		}
	}
}

function checkUpdateMsg() {
	document.getElementById('update').innerText = getLocalizedString('Check for ladyCrypt updates');
}

function downloadUpdate(wdo) {
	var dlButton = document.getElementById('download_btn');
	var ckButton = document.getElementById('update_btn');
	if (wdo) {
		ckButton.style.visibility = "hidden";
		dlButton.style.visibility = "visible";
	}
	else {
		ckButton.style.visibility = "visible";
		dlButton.style.visibility = "hidden";
	}
}

function showUpdates(wdo) {
	var updateStatus = document.getElementById('update');
	if (wdo) {
		if (checkVersionStatus) {
			updateStatus.innerText = getLocalizedString('ladyCrypt update available');
			downloadUpdate(true);
		}
		else {
			updateStatus.innerText = getLocalizedString('ladyCrypt is up to date');
			setTimeout("checkUpdateMsg();", 5000);
		}
	}
	else
		checkUpdateMsg();
}



function getWidgetInfos(infos,what) {
	var pos = infos.indexOf('@');
	if (what == 'name') {		
		return infos.substring(0, pos);
	}
	else if (what == 'version') {
		return infos.substring(pos+1, infos.length);
	}
}

function ladySoftwareUpdate(wid, ver) {
	var XMLfeed = XMLRequest.responseXML;
	var items = XMLfeed.getElementsByTagName("item");
	var widId = null;
	for (i=0; i<items.length; i++) {
		if (getWidgetInfos(items[i].childNodes[11].firstChild.nodeValue.toLowerCase(), 'name') == wid.toLowerCase())
			widId = i;
	}
	if (widId) {
		var upVer = getWidgetInfos(items[widId].childNodes[11].firstChild.nodeValue, 'version');
		if (ver < upVer)
			return true;
		else
			return false;
	}
	else
		return false;
}
/*--------------------------------------------------------------------*/
function createKey (key) {
	return widget.identifier + "-" + key
}

function logoClicked(){
	if (window.widget){
		widget.openURL('http://www.ladybug.fr/goodies.html');
	}
}

function getLocalizedString (key) {
	try {
		var ret = localizedStrings[key];
		if (ret === undefined)
			ret = key;
		return ret;
	} catch (ex) {}
	
	return key;
}

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event) {
	if (!flipShown) {
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer  = null;
		}
				
		var starttime = (new Date).getTime() - 13;
				
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.6;
		animate();
		flipShown = true;
	}
}

function mouseexit (event) {
	if (flipShown) {
		// fade in the info button
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer  = null;
		}
				
		var starttime = (new Date).getTime() - 13;
				
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function animate() {
	var T;
	var ease;
	var time = (new Date).getTime();

	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration) {
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c) {
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
	return from + (to - from) * ease;
}

function enterflip(event) {
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
	document.getElementById('fliprollie').style.display = 'none';
}


/* preferences flip
------------------------------------------------ */

function doneClicked(){
	hidePrefs();
	
	mouseexit(event);
	exitflip(event)
}

function showPrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	showUpdates(false);
	downloadUpdate(false);
	
	if (window.widget) {
		window.resizeTo(368, 94);
		widget.prepareForTransition("ToBack");
	}

	front.style.display="none";
	back.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}

function hidePrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
		
	if (window.widget) {
		widget.prepareForTransition("ToFront");
		if (optionsShown)
			window.resizeTo(368, 64);
		else
			window.resizeTo(368, 58);
		
	}
		
	back.style.display="none";
	front.style.display="block";
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}